(function($){

window.PrettyRoutes = {};
PrettyRoutes.Map = function(settings) {
	for (var prop in settings) {
		this[prop] = settings[prop];
	}

	this.refresh = function() {
		if (this.center_mode == 'auto') {
			this.map.fitBounds(this.map._routes.bounds);
		}
	}

    this.center = this.center.split(',');
	this.center = new google.maps.LatLng(this.center[0], this.center[1]);
	var opts = {
        'zoom': this.zoom,
        'center': this.center,
        'mapTypeId': google.maps.MapTypeId.ROADMAP,
        'panControl': true,
        'zoomControl': true,
        'mapTypeControl': true,
        'scaleControl': true,
        'streetViewControl': false,
        'overviewMapControl': true
    }
	this.map = new google.maps.Map(this.container.get(0), opts);
}
PrettyRoutes.Route = function(settings) {
	for (var prop in settings) {
		this[prop] = settings[prop];
	}

	this.createTooltip = function(rgba) {
		for (var type in this.pins) {
			var pin = this.pins[type];
			if (!pin.tooltip_enabled) {
				continue;
			}

			var tooltip = $('<div></div>')
				.addClass('route-pin')
				.addClass('route-pin-' + this.id + '-' + type);
			tooltip.append($('<div class="top"></div>'));
			tooltip.append(
				$('<div class="center" style="background: rgba(' + rgba[0] + ', ' + rgba[1] + ', ' + rgba[2] + ', ' + rgba[3] + ');"></div>')
					.append('<p>' + pin.tooltip + '</p>')
			);
			tooltip.append($('<div class="bottom" style="border-top: 20px solid rgba(' + rgba[0] + ', ' + rgba[1] + ', ' + rgba[2] + ', ' + rgba[3] + ');"></div>'));
			$('body').append(tooltip);
			this.pins[type].tooltip_node = tooltip;
		}
	}

	this.setMap = function(container, map) {
		this.container = container;
		this.map = map;
		if (!this.valid) {
			return false;
		}

		if (typeof this.map._routes == 'undefined') {
		    var overlay = new google.maps.OverlayView();
			overlay.draw = function() {};
			overlay.setMap(this.map);
			this.map._routes = {
				'overlay': overlay,
				'directionsService': new google.maps.DirectionsService(),
				'bounds': new google.maps.LatLngBounds()
			}
		}

		for (var type in this.pins) {
			var p = this.pins[type];
			this.pins[type].latlng = new google.maps.LatLng(p.geocoords[0], p.geocoords[1]);
			var opts = {
		        'position': this.pins[type].latlng,
		        'map': this.map,
		        'draggable': false
		    }
		    if (p.pin_image) {
		    	opts.icon = p.pin_image;
		    }

			var marker = new google.maps.Marker(opts);
			marker._routes = {
				'route': this,
				'pin_type': type,
				'pin_anchor': p.pin_anchor
			}

		    google.maps.event.addListener(marker, 'mouseover', function(){
		    	var settings = this._routes;
		    	var tooltip = settings.route.pins[settings.pin_type].tooltip_node;
		    	var proj = settings.route.map._routes.overlay.getProjection();
				var pos = this.getPosition();
				var p = proj.fromLatLngToContainerPixel(pos);

		    	var anchor_x = 0;
		    	var anchor_y = -10;
		    	if (this.getIcon()) {
		    		anchor_y -= settings.pin_anchor[1];
		    	} else {
		    		anchor_y -= 40; // default google pin height
		    	}
		    	if (tooltip) {
			    	tooltip.show().css({
			    		top: settings.route.container.offset().top + p.y - tooltip.height() + anchor_y,
			    		left: settings.route.container.offset().left + p.x - Math.ceil(tooltip.width() / 2) + anchor_x
			    	});
		    	}
		    });
		    google.maps.event.addListener(marker, 'mouseout', function(){
		    	var settings = this._routes;
		    	var tooltip = settings.route.pins[settings.pin_type].tooltip_node;
		    	if (tooltip) {
		    		tooltip.hide();
		    	}
		    });

			this.map._routes.bounds.extend(opts.position);
		}

	    var directionsRendererOptions = {
			'hideRouteList': true,
			'suppressInfoWindows': true,
			'preserveViewport': true,
			'suppressMarkers': true,
			'polylineOptions': {
				'strokeWeight': 6,
				'strokeOpacity': 0.6,
				'strokeColor': this.stroke_color
			}
		};

		var renderer_type = this.type;
		if (renderer_type == 'road') {
			var renderer = new google.maps.DirectionsRenderer(directionsRendererOptions);
			var request = {
				'origin': this.pins.origin.latlng,
				'destination': this.pins.destination.latlng,
				'travelMode': google.maps.DirectionsTravelMode.DRIVING
			}
			if (typeof this.pins['waypoint_0'] != 'undefined') { // has at least 1 waypoint
				request.waypoints = [];
				for (var type in this.pins) {
					if (type == 'origin' || type == 'destination') {
						continue;
					}
					request.waypoints.push({
						'location': new google.maps.LatLng(this.pins[type].geocoords[0], this.pins[type].geocoords[1])
					});
				}
			}

			this.map._routes.directionsService.route(request, function(response, status) {
				if (status == google.maps.DirectionsStatus.OK) {
					renderer.setDirections(response);
				}
			});
		} else {
			var renderer = new google.maps.Polyline(directionsRendererOptions.polylineOptions);
			var path = [];
			for (var type in this.pins) {
				path.push(this.pins[type].latlng);
			}
			renderer.setPath(path);
		}
		renderer.setMap(map);
	}

}

})(jQuery);